package pl.vorg.mowa.core.graphics;

/**
 * The base class of a vertex attribute used in buffers.
 * 
 * @author vorg
 */
public abstract class VertexAttrib {
	/**
	 * The attribute's name IS meaningful and it corresponds to the attribute's
	 * semantics. Basic attributes are, e.g.: pos, normal, texCoord0.
	 */
	private String name = "";

	/**
	 * Number of elements that an attributes contains. E.g., a position contains
	 * 3 floats x,y,z. It should be used in VertexArrays, however, since they
	 * don't work in JOGL under OSX, those values are hard-coded in
	 * Geometry.displayImmediately(), and the dataType field hasn't been used.
	 */
	private int dataType;

	/**
	 * Constructor.
	 * 
	 * @param name
	 *            The attribute's name. It IS meaningful and it corresponds to
	 *            the attribute's semantics. Basic attributes are, e.g.: pos,
	 *            normal, texCoord0.
	 */
	public VertexAttrib(String name) {
		this.name = name;
	}

	/**
	 * @return Number of elements that an attributes contains.
	 */
	public int getDataType() {
		return dataType;
	}

	public void setDataType(int dataType) {
		this.dataType = dataType;
	}

	public String getName() {
		return name;
	}

	/**
	 * Sets the attribute's name. It IS meaningful and it corresponds to the
	 * attribute's semantics. Basic attributes are, e.g.: pos, normal,
	 * texCoord0.
	 * 
	 * @param name
	 *            The attribute's name.
	 */
	public void setName(String name) {
		this.name = name;
	}
}
