package pl.vorg.mowa.core.graphics;

/**
 * A vector in 2d space.
 * 
 * @author vorg
 */
public class Vec2 {
	private float[] v = {0,0};
	
	public Vec2() {
		
	}
	
	public Vec2(float x, float y) {
		v[0] = x;
		v[1] = y;
	}
	
	public Vec2(Vec2 vec) {
		float[] w = vec.getVector();
		v[0] = w[0];
		v[1] = w[1];
	}
	
	public Vec2(float[] vec) {
		v[0] = vec[0];
		v[1] = vec[1];
	}
	
	@Override
	public boolean equals(java.lang.Object obj) {
		float[] w = ((Vec2)obj).getVector();
		return (v[0] == w[0]) && (v[1] == w[1]); 
	}
	
	public float getX() {
		return v[0];
	}
	
	public float getY() {
		return v[1];
	}
	
	public float getS() {
		return v[0];
	}
	
	public float getT() {
		return v[1];
	}
	
	public void setX(float x) {
		v[0] = x;
	}
	
	public void setY(float y) {
		v[1] = y;
	}
	
	public void setS(float s) {
		v[0] = s;
	}
	
	public void setT(float t) {
		v[1] = t;
	}
	
	public float[] getVector() {
		return v;
	}
	
	public void normalize() {
		float length = length();
		if (length > 0) {
			v[0] /= length;
			v[1] /= length;
		}
	}
	
	public float length() {
		return (float)Math.sqrt(v[0]*v[0]+v[1]*v[1]);
	}
	
	public float dot(Vec2 a) {
		float[] va = a.getVector();
		return v[0]*va[0] + v[1]*va[1];
	}
	
	public float angle(Vec2 a) {
		float len = length();
		float alen = a.length();
		if ((len == 0) || (alen == 0)) {
			return 0;
		}
		return (float)Math.acos(this.dot(a)/(len*alen));
	}
	
	public static float angle(Vec2 a, Vec2 b) {
		return a.angle(b);
	}
	
	public static float angleTan(Vec2 a, Vec2 b) {
		double angle = Math.atan2(a.getY(),a.getX()) - Math.atan2(b.getY(),b.getX());
		return (float)angle;
	}
}
