package pl.vorg.mowa.core.graphics;

import java.io.File;
import java.nio.Buffer;

import javax.media.opengl.GL;

import com.framsticks.net.client3D.Log;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;

/**
 * An environment texture. 
 */
public class SkyBox {

	Buffer buf;

	public boolean Init(GL gl) {

		return Init(gl, new String("res/img/Front.PNG"), new String(
				"res/img/Back.PNG"), new String("res/img/Left.PNG"),
				new String("res/img/Right.PNG"), new String("res/img/Top.PNG"),
				new String("res/img/Bottom.PNG"));

	}

	public boolean Init(GL gl, String front, String back, String left,
			String right, String top, String bottom) {
		try {
			m_tFront = LoadTex(front);
			m_tBack = LoadTex(back);
			m_tLeft = LoadTex(left);
			;
			m_tRight = LoadTex(right);
			m_tTop = LoadTex(top);
			m_tBottom = LoadTex(bottom);
			CreateCube(gl, front, back, left, right, top, bottom);
		} catch (Exception e) {
			Log.getInstance().log("err",
					"SkyBox: Error while loading textures! " + e.getMessage());
			return false;
		}
		return true;
	}

	Texture LoadTex(String fileName) throws Exception {
		Texture result = TextureIO.newTexture(new File(fileName), false);

		result.setTexParameteri(GL.GL_TEXTURE_WRAP_S, GL.GL_NONE);
		result.setTexParameteri(GL.GL_TEXTURE_WRAP_T, GL.GL_NONE);
		return result;

	}

	public void Draw(GL gl, float boxSize, Vec3 rot) {
		boolean light = gl.glIsEnabled(GL.GL_LIGHTING);
		gl.glDisable(GL.GL_LIGHTING);
		float size = boxSize * (1.72f / 3);
		// float pozx = 0 ,pozy = 0 ,pozz = 0;
		// float clip = g_CCamera.m_fFarClip;
		// g_CCamera.m_fFarClip = 1000;
		// g_CCamera.Set();
		gl.glPushMatrix();
		gl.glLoadIdentity();
		// glTranslatef(g_CCamera.GetPosition().x,g_CCamera.GetPosition().y,g_CCamera.GetPosition().z);
		gl.glRotatef(rot.getX(), 1, 0, 0);
		gl.glRotatef(rot.getY(), 0, 1, 0);
		gl.glRotatef(rot.getZ(), 0, 0, 1);
		gl.glDepthMask(false);
		gl.glEnable(GL.GL_TEXTURE_2D);
		m_tFront.bind();
		gl.glColor4f(1.0f, 1.0f, 1.0f, 0.0f);
		// gl.glBlendFunc(GL.GL_SRC_ALPHA, GL.GL_DST_COLOR);
		// gl.glEnable(GL.GL_BLEND);
		gl.glBegin(GL.GL_QUADS);
		// front

		gl.glTexCoord2d(1, 1);
		gl.glVertex3f((float) -size, (float) -size, (float) -size);
		gl.glTexCoord2d(0, 1);
		gl.glVertex3f((float) size, (float) -size, (float) -size);
		gl.glTexCoord2d(0, 0);
		gl.glVertex3f((float) size, (float) size, (float) -size);
		gl.glTexCoord2d(1, 0);
		gl.glVertex3f((float) -size, (float) size, (float) -size);
		gl.glEnd();
		// back
		m_tBack.bind();
		gl.glBegin(GL.GL_QUADS);
		gl.glTexCoord2d(0, 1);
		gl.glVertex3f((float) -size, (float) -size, (float) size);
		gl.glTexCoord2d(0, 0);
		gl.glVertex3f((float) -size, (float) size, (float) size);
		gl.glTexCoord2d(1, 0);
		gl.glVertex3f((float) size, (float) size, (float) size);
		gl.glTexCoord2d(1, 1);
		gl.glVertex3f((float) size, (float) -size, (float) size);
		gl.glEnd();
		// left
		m_tLeft.bind();
		gl.glBegin(GL.GL_QUADS);
		gl.glTexCoord2d(0, 1);
		gl.glVertex3f((float) -size, (float) -size, (float) -size);
		gl.glTexCoord2d(0, 0);
		gl.glVertex3f((float) -size, (float) size, (float) -size);
		gl.glTexCoord2d(1, 0);
		gl.glVertex3f((float) -size, (float) size, (float) size);
		gl.glTexCoord2d(1, 1);
		gl.glVertex3f((float) -size, (float) -size, (float) size);
		gl.glEnd();
		// Right
		m_tRight.bind();
		gl.glBegin(GL.GL_QUADS);
		gl.glTexCoord2d(1, 1);
		gl.glVertex3f((float) size, (float) -size, (float) -size);
		gl.glTexCoord2d(0, 1);
		gl.glVertex3f((float) size, (float) -size, (float) size);
		gl.glTexCoord2d(0, 0);
		gl.glVertex3f((float) size, (float) size, (float) size);
		gl.glTexCoord2d(1, 0);
		gl.glVertex3f((float) size, (float) size, (float) -size);
		gl.glEnd();
		// Top
		m_tTop.bind();

		gl.glBegin(GL.GL_QUADS);
		gl.glTexCoord2d(1, 0);
		gl.glVertex3f((float) -size, (float) size, (float) size);
		gl.glTexCoord2d(1, 1);
		gl.glVertex3f((float) -size, (float) size, (float) -size);
		gl.glTexCoord2d(0, 1);
		gl.glVertex3f((float) size, (float) size, (float) -size);
		gl.glTexCoord2d(0, 0);
		gl.glVertex3f((float) size, (float) size, (float) size);
		gl.glEnd();
		// Bottom
		m_tBottom.bind();

		gl.glBegin(GL.GL_QUADS);
		gl.glTexCoord2d(1, 0);
		gl.glVertex3f((float) -size, (float) -size, (float) -size);
		gl.glTexCoord2d(1, 1);
		gl.glVertex3f((float) -size, (float) -size, (float) size);
		gl.glTexCoord2d(0, 1);
		gl.glVertex3f((float) size, (float) -size, (float) size);
		gl.glTexCoord2d(0, 0);
		gl.glVertex3f((float) size, (float) -size, (float) -size);
		gl.glEnd();
		gl.glBindTexture(GL.GL_TEXTURE_2D, 0);
		// gl.glDisable(GL.GL_BLEND);
		// glEnable(GL_FOG);
		gl.glPopMatrix();
		if (light)
			gl.glEnable(GL.GL_LIGHTING);
		gl.glDepthMask(true);
	}

	private int[] textureCubeMapId;

	void CreateCube(GL gl, String front, String back, String left,
			String right, String top, String bottom) {
		textureCubeMapId = new int[1];
		int internalFormat = 0, format = 0, face = 0;

		gl.glPixelStorei(GL.GL_UNPACK_ALIGNMENT, 1);
		gl.glGenTextures(1, textureCubeMapId, 0);
		gl.glBindTexture(GL.GL_TEXTURE_CUBE_MAP, textureCubeMapId[0]);

		gl.glTexParameteri(GL.GL_TEXTURE_CUBE_MAP, GL.GL_TEXTURE_WRAP_S,
				GL.GL_CLAMP_TO_EDGE);
		gl.glTexParameteri(GL.GL_TEXTURE_CUBE_MAP, GL.GL_TEXTURE_WRAP_T,
				GL.GL_CLAMP_TO_EDGE);
		gl.glTexParameteri(GL.GL_TEXTURE_CUBE_MAP, GL.GL_TEXTURE_MAG_FILTER,
				GL.GL_LINEAR);
		gl.glTexParameteri(GL.GL_TEXTURE_CUBE_MAP, GL.GL_TEXTURE_MIN_FILTER,
				GL.GL_LINEAR);
		TextureData texDataFront = null;
		TextureData texDataBack = null;
		TextureData texDataLeft = null;
		TextureData texDataRight = null;
		TextureData texDataTop = null;
		TextureData texDataBottom = null;
		try {
			texDataFront = TextureIO
					.newTextureData(new File(front), true, null);
			texDataBack = TextureIO.newTextureData(new File(back), true, null);
			texDataLeft = TextureIO.newTextureData(new File(left), true, null);
			texDataRight = TextureIO
					.newTextureData(new File(right), true, null);
			texDataTop = TextureIO.newTextureData(new File(top), true, null);
			texDataBottom = TextureIO.newTextureData(new File(bottom), true,
					null);
		} catch (Exception e) {
			Log.getInstance().log(
					"err",
					"SkyBox: Error while generating cube textures! "
							+ e.getMessage());
		}
		TextureData active = texDataFront;
		for (int i = 0; i < 6; i++) {

			switch (i) {
			case 0:
				face = GL.GL_TEXTURE_CUBE_MAP_POSITIVE_X;
				active = texDataRight;
				break;
			case 1:
				face = GL.GL_TEXTURE_CUBE_MAP_NEGATIVE_X;
				active = texDataLeft;
				break;
			case 2:
				face = GL.GL_TEXTURE_CUBE_MAP_POSITIVE_Y;
				active = texDataTop;
				break;
			case 3:
				face = GL.GL_TEXTURE_CUBE_MAP_NEGATIVE_Y;
				active = texDataBottom;
				break;
			case 4:
				face = GL.GL_TEXTURE_CUBE_MAP_POSITIVE_Z;
				active = texDataBack;
				break;
			case 5:
				face = GL.GL_TEXTURE_CUBE_MAP_NEGATIVE_Z;
				active = texDataFront;
				break;
			}
			internalFormat = active.getInternalFormat();
			internalFormat = GL.GL_RGB8;
			// format = active.getPixelFormat() ;
			format = GL.GL_RGB;

			// for (int j=0; j< active.getMipmapData().length; j++)
			// gl.glTexImage2D(face, j, internalFormat, active.getWidth(),
			// active.getHeight(),0, format, GL.GL_UNSIGNED_BYTE,
			// active.getMipmapData()[j]);
			gl.glTexImage2D(face, 0, internalFormat, active.getWidth(),
					active.getHeight(), 0, format, GL.GL_UNSIGNED_BYTE,
					active.getBuffer());
		}

	}

	public int getCube() {
		return textureCubeMapId[0];
	}

	// void Kill() {m_tFront(); m_tBack.Free(); m_tLeft.Free(); m_tRight.Free();
	// m_tTop.Free(); m_tBottom.Free();}

	Texture m_tFront;
	Texture m_tBack;
	Texture m_tLeft;
	Texture m_tRight;
	Texture m_tTop;
	Texture m_tBottom;
}
