package pl.vorg.mowa.core.graphics;

import java.util.ArrayList;

import javax.media.opengl.GL;

/**
 * A 3d model, containing many 3d shapes.
 * 
 * @author vorg
 */
public class GeometryGroup {
	private ArrayList<Geometry> children = new ArrayList<Geometry>();
	private BoundingBox boundingBox = new BoundingBox();

	public ArrayList<Geometry> getChildren() {
		return children;
	}

	public void setChildren(ArrayList<Geometry> value) {
		this.children = value;
	}
	
	public BoundingBox getBoundingBox() {
		return boundingBox;
	}
	
	public void display(GL gl) {
		for(Geometry geometry : children) {
			geometry.display(gl);
		}
	}
	
	public void updateBoundingBox() {
		boundingBox.empty();
		for(Geometry geometry : children) {
			if (geometry.getBoundingBox().isEmpty()) {
				geometry.updateBoundingBox();
			}
			boundingBox.add(geometry.getBoundingBox());
		}
	}
	
}
