//size versus energy
//real proportions

// -------------------------------- step begin --------------------------------

function reproduce_haploid(parent, parent2)
{
	var number = parent.user2["Va"] / ExpParams.energy0d + parent2.user2["Va"] / ExpParams.energy0d;

	for (var j = 0; j < number; j++)
	{
		createOffspring(ExpParams.gend, ExpParams.energy0d, [parent.user1, parent2.user1], {"Va" : ExpParams.energy0d, "gen" : 1 , "growth_step" : ExpParams.growth_step, "rsize": ExpParams.rads[1], "vinit": ExpParams.energy0d}); //TODO genes from both generations in user1
	}
}

function reproduce_diploid(parent)
{
	var number = parent.user2["Va"] / ExpParams.energy0h;
	for (var j = 0; j < number / 2; j++)
	{
		var crossed = 0;
		//crossover
		if (Math.rnd01 < ExpParams.crossprob)
		{
			crossover(parent, "minenergy");
			crossed = 1;
		}

		for (var k = 0; k < 2; k++)
		{
			createOffspring(ExpParams.genh, ExpParams.energy0h, {"minenergy" : ExpParams.minenerg[0], "minage": ExpParams.minage[0]}, {"Va" : ExpParams.energy0h, "gen" : 0 , "growth_step" : ExpParams.growth_step, "rsize" : ExpParams.rads[0], "vinit": ExpParams.energy0h}); //TODO different vamin and amin for haploids and diploids?
		}

		//reverse of crossover for fossilization
		if (crossed == 1)
		{
			crossover(parent, "minenergy");
			crossed = 0;
		}
			
	}
}

function crossover(parent, gene)
{
	var tmp = parent.user1[0][gene];
	parent.user1[0][gene] = parent.user1[1][gene];
	parent.user1[1][gene] = tmp;
}


function createOffspring(geno, energy, new_user1, new_user2)
{
	var cr = Populations[0].add(geno);
	cr.energy0 = energy;
	cr.energy = cr.energy0;
	setGenotype(cr, new_user1, new_user2);
	placeRandomlyNotColliding(cr);
}

function onStep()
{

	if (ExpParams.logging == 1)
	{
		createStatistics();
	}

	//nutrient growth ---------------------------------------------
	nutrientenergywaiting = nutrientenergywaiting + ExpParams.feedrate;
	if (nutrientenergywaiting > ExpParams.feede0)
	{
		for (var i = 0; i < ExpParams.nutrientPop; i++)
		{
			addNutrient();
		}

		nutrientenergywaiting = 0.0;
		Simulator.checkpoint();
	}

	//reproduction --------------------------------------------
	reprocounter += 1;
	if (reprocounter > ExpParams.repro_time)
	{
		reprocounter = 0;
		var parent1 = null;
		var parent2 = null;
		var pop = Populations[0];
		for (var i = pop.size-1; i >= 0; i--)
		{
   			if (pop[i].signals.size > 0) 
   			{ 
				if (pop[i].user2["gen"]==1)
				{
					reproduce_diploid(pop[i]);
					pop.kill(i);
				}
      				else if (parent1 == null)
				{
					parent1 = pop[i];
				}
				else if (parent2 == null)
				{
					parent2 = pop[i];
				}  
				else
				{
					reproduce_haploid(parent1, parent2);
					pop.kill(parent1);
					pop.kill(parent2);
					parent1 = null;
					parent2 = null;
				}
      		
   			} 
		}
	}

	//check for death -----------------------------------------------
	if (Populations[0].size == 0)
	{
		if (ExpParams.autorestart)
		{
			Simulator.print("no more creatures, restarting...");
			onExpInit();
		}
		else
		{
			Simulator.print("no more creatures, stopped.");
			Simulator.stop();
		}
	}
}

function createStatistics()
{
	var haploids = 0;
	var diploids = 0;
	var e_inc_h = 0.0;
	var e_inc_d = 0.0;
	var e_nut = 0.0;
	var size_h = 0.0;
	var size_d = 0.0;
	var vmin_h = 0.0;
	var vmin_d = 0.0;

	for (var i = 0; i < Populations[0].size; i++)
	{
		var cr = Populations[0].get(i);
		if (cr.user2["gen"] == 0)
		{
			haploids += 1;
			e_inc_h += cr.energy;
			size_h += ExpParams.rads[0]; //TODO change of size dependent on gene
			vmin_h += cr.user1["minenergy"];
		}
		else if (cr.user2["gen"] == 1)
		{
			diploids += 1;
			e_inc_d += cr.energy;
			size_d += ExpParams.rads[1]; //TODO change of size dependent on gene
			vmin_d += cr.user1[0]["minenergy"];
		}
	}

	for (var i = 0; i < Populations[1].size; i++)
	{
		var cr = Populations[1].get(i);
		e_nut += cr.energy;
	}

	var l1 = [haploids, diploids, Populations[1].size];
	var l2 = [e_inc_h, e_inc_d, e_nut];
	var dp = diploids;
	var hp = haploids;
	if (dp == 0) dp = 0.000001;
	if (hp == 0) hp = 0.000001;
	var l3 = [size_h / hp, vmin_h / hp, size_d / dp, vmin_d / dp];

	log(l1, "log_sizes.txt");
	log(l2, "log_energy.txt");
	log(l3, "log_sizes_v.txt");
}
// -------------------------------- step end --------------------------------
