// This file is a part of Framsticks SDK.  http://www.framsticks.com/
// Copyright (C) 1999-2015  Maciej Komosinski and Szymon Ulatowski.
// See LICENSE.txt for details.

#include "stdiofile.h"
#include <common/nonstd_dir.h>
#include <common/nonstd_stdio.h>
#include <common/hmessage.h>
#include <common/Convert.h>

VirtFILE* StdioFileSystem::Vfopen(const char *path, const char *mode)
{
	//printH("Vfopen %s %s",path,mode);
#ifdef _WIN32
	FILE *f = _wfopen(Convert::utf8ToUtf16(path).c_str(), Convert::strTOwstr(mode).c_str());
#else
#ifdef USE_MFILE
	MFILE *f = mfopen(path, mode);
#else
	FILE *f = fopen(path, mode);
#endif
#endif
	//printH("%p",f);
	if (f) return new StdioFILE(f, path); else return NULL;
}

VirtDIR* StdioFileSystem::Vopendir(const char* path)
{
	//printH("Vopendir %s",path);
#ifdef _WIN32
	DIRTYPE *d = wopendir(Convert::utf8ToUtf16(path).c_str());
#else
	DIR *d = opendir(path);
#endif
	//printH("%p",d);
	if (d) return new StdioDIR(d); else return NULL;
}

bool StdioFileSystem::Vfexists(const char* path)
{
	return fileExists(path);
}

void StdioFILE::setStdio()
{
#ifndef NO_STD_IN_OUT_ERR
	static StdioFILEDontClose si(stdin);
	static StdioFILEDontClose so(stdout);
	static StdioFILEDontClose se(stderr);
	setVstdin(&si);
	setVstdout(&so);
	setVstderr(&se);
#endif
}

dirent* StdioDIR::Vreaddir()
{
	//printH("Vreaddir %s",dir);
#ifdef _WIN32
	wdirent *wde=wreaddir(dir);
	if (wde==NULL) return NULL;
	strcpy(de.d_name, Convert::wstrToUtf8(wde->d_name).c_str());
	return &de;
#else
	return readdir(dir);
#endif
}
