// This file is a part of Framsticks SDK.  http://www.framsticks.com/
// Copyright (C) 1999-2015  Maciej Komosinski and Szymon Ulatowski.
// See LICENSE.txt for details.

#include "stdouterr.h"
#ifdef SHP
#include <FBaseSys.h> //AppLog
#else
#include <stdio.h>
#endif

void StdoutErrorHandler::handle(const char *o, const char *m, const char *bl, int w)
{
	if (w < -1) w = -1; else if (w>3) w = 3;
#ifdef SHP
	AppLog("[%s] %s::%s - %s\n",MSG_LEVEL[w+1],o,m,bl);
#else
	if (file)
		file->printf("[%s] %s::%s - %s\n", MSG_LEVEL[w + 1], o, m, bl);
	else
		printf("[%s] %s::%s - %s\n", MSG_LEVEL[w + 1], o, m, bl);
#endif
}
