// This file is a part of Framsticks SDK.  http://www.framsticks.com/
// Copyright (C) 1999-2015  Maciej Komosinski and Szymon Ulatowski.
// See LICENSE.txt for details.

#include "stderrors.h"
#include <frams/util/sstringutils.h>
#include <common/framsg.h>

bool listIndexCheck(SList* list,int index,const char* msgobj,const char* msgfun)
{
	int size=list->size();
if ((index<0)||(index>=size))
	{
	if (size>0) 
		FMprintf(msgobj,msgfun,FMLV_ERROR,"Invalid index %d (allowed range is 0..%d)",index,size-1);
	else
		FMprintf(msgobj,msgfun,FMLV_ERROR,"Invalid index %d (this list is empty)",index);
	return 0;
	}
return 1;
}

SString stringCheck(SString& in,const char* msgobj,const char* msgfun,const char* msg,SString (*checker)(SString& in))
{
if (!checker)
	checker=trim;
SString corrected=checker(in);
if (corrected!=in)
	{
	SString msg2=SString(msg)+": \"%s\" (adjusted to \"%s\")";
	FMprintf(msgobj,msgfun,FMLV_WARN,(const char*)msg2,(const char*)in,(const char*)corrected);
	}
return corrected;
}
