// This file is a part of Framsticks SDK.  http://www.framsticks.com/
// Copyright (C) 1999-2015  Maciej Komosinski and Szymon Ulatowski.
// See LICENSE.txt for details.

#include "errmanager.h"
#include <common/stl-util.h>

void _FramMessageSingleLine(const char *o, const char *m, const char *txt, int w)
{
tlsGetRef(errmgr_instance).send(o,m,txt,w);
}

THREAD_LOCAL_DEF(ErrorManager,errmgr_instance);

void ErrorManager::send(int level,const char *o,const char *m,const char *bl,int w)
{
if (level>=handlers.size()) level=handlers.size()-1;
bool blocked=0;
for(int i=level;i>=0;i--)
	{
	ErrorHandlerBase *r=handlers(i);
	if ((!blocked)||(r->options & ErrorHandlerBase::CannotBeBlocked))
		r->handle(o,m,bl,w);
	if (!(r->options & ErrorHandlerBase::DontBlock)) blocked=1;
	}
}

int ErrorManager::add(ErrorHandlerBase *h)
{
h->mgr=this;
handlers+=h;
return handlers.size()-1;
}

void ErrorManager::remove(int i)
{
ErrorHandlerBase *h=handlers(i);
h->mgr=0;
handlers.remove(i);
}

void ErrorManager::remove(ErrorHandlerBase *h)
{
int i;
if ((i=handlers.find(h))<0) return;
remove(i);
}

void ErrorManager::removeAll()
{
while(handlers.size()>0)
	remove(handlers.size()-1);
}

//////////////////////////////////

void ErrorHandlerBase::send(const char *o,const char *m,const char *bl,int w)
{
if (!isEnabled()) return;
int level=mgr->find(this);
if (level>=0) mgr->send(level-1,o,m,bl,w);
}

void ErrorHandlerBase::FMprintf(const char *o,const char *m,int w,const char *bl, ...)
{
if (!isEnabled()) return;
string buf;
va_list argptr;
va_start(argptr,bl);
buf=ssprintf_va(bl,argptr);
va_end(argptr);
send(o,m,buf.c_str(),w);
}


void ErrorHandlerBase::enable()
{
if (isEnabled()) return;
tlsGetRef(errmgr_instance).add(this);
}

void ErrorHandlerBase::disable()
{
if (!isEnabled()) return;
tlsGetRef(errmgr_instance).remove(this);
}

/////////////////////////////////

void ErrorHandler::handle(const char *o,const char *m,const char *bl,int w)
{
if (w>maxlevel) maxlevel=w;
if (w>=FMLV_INFO) infocount++;
if (w>=FMLV_WARN) warncount++;
if (w>=FMLV_ERROR) errcount++;

if (w>=storlevel)
	{
	storcount++;
	if (options & (StoreFirstMessage|StoreAllMessages))
		{
		if (!((options&StoreFirstMessage)&&(msgs.len()>0)))
			{
			if (msgs.len()>0) msgs+='\n';
			msgs+=o; msgs+="::"; msgs+=m;
			msgs+=" - "; msgs+=bl;
			}
		}
	}
}
