	package cecj.archive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import ec.EvolutionState;
import ec.Group;
import ec.Individual;
import ec.Subpopulation;
import ec.util.Parameter;

public class ArchivingSubpopulation extends Subpopulation {

	List<Individual> archiveIndividuals;

	@Override
	public void setup(EvolutionState state, Parameter base) {
		super.setup(state, base);
		archiveIndividuals = new ArrayList<Individual>();
	}
	
	@Override
	public Group emptyClone() {
		ArchivingSubpopulation subpopulation = (ArchivingSubpopulation) super.emptyClone();
		subpopulation.archiveIndividuals = archiveIndividuals;
		return subpopulation;
	}
	

	public List<Individual> getArchivalIndividuals() {
		return archiveIndividuals;
	}
	
	public List<Individual> getIndividuals() {
		return Arrays.asList(individuals);
	}
}
