#include "modelgeoclass.h"
#include "modelgeometryinfo.h"
#include <frams/vm/classes/collectionobj.h>
#include <frams/vm/classes/3dobject.h>

#define FIELDSTRUCT ModelGeometry
static ParamEntry modelgeo_paramtab[]=
{
 {"Creature: Geometry",1,5,"ModelGeometry",
  "Example usage:\n"
  "Simulator.print(ModelGeometry.forModel(Model.newFromString(\"//0\\np:sh=1\\n\")).area());\n"
  "ModelGeometry.geodensity refers to the global simulator parameter (also available in GUI).\n"
  "Local geodensity of individual ModelGeometry objects can also be changed, like this:\n"
  "var mg=ModelGeometry.forModel(GenePools[0][0].getModel()); mg.geodensity=2; GenePools[0][0].user1=mg.area();\n"},
 {"geodensity",0,0,"Density","f 0.01 100.0 1.0",FIELD(density),"Affects the geometry calculation precision"}, //note: geodensity instead of density to make the name more unique - because of the unfortunate sim_params merging all configuration fields in a single namespace
{"forModel",0,PARAM_USERHIDDEN,"","p oModelGeometry(oModel)",PROCEDURE(p_formodel),"The returned ModelGeometry object can be used to calculate geometric properties of the associated model (volume, area, sizes). The density is copied from the current global ModelGeometry.geodensity on object creation."},
{"volume",0,PARAM_NOSTATIC|PARAM_USERHIDDEN,"volume","p f()",PROCEDURE(p_volume),},
{"area",0,PARAM_NOSTATIC|PARAM_USERHIDDEN,"area","p f()",PROCEDURE(p_area),},
{"sizesAndAxes",0,PARAM_NOSTATIC|PARAM_USERHIDDEN,"sizesAndAxes","p oVector()",PROCEDURE(p_sizesandaxes),"The returned vector contains XYZ (sizes) and Orient (axes) objects."},

{0,0,0,},
};
#undef FIELDSTRUCT

ExtObject ModelGeometry::makeDynamicObject(ModelGeometry* mg)
{return ExtObject(&mg->par,mg);}

ModelGeometry::ModelGeometry(ModelObj *mo)
	:par(modelgeo_paramtab,this)
{
model=mo;
if (model!=NULL)
	model->incref();
}

ModelGeometry::~ModelGeometry()
{
if (model!=NULL)
	model->decref();
}

void ModelGeometry::p_formodel(ExtValue *args,ExtValue *ret)
{
Model *m=ModelObj::fromObject(*args);
if (m!=NULL)
	{
	ModelGeometry *mg=new ModelGeometry((ModelObj*)m);
	mg->density=density;
	ret->setObject(ModelGeometry::makeDynamicObject(mg));
	}
else
	ret->setEmpty();
}

void ModelGeometry::p_volume(ExtValue *args,ExtValue *ret)
{
ret->setDouble(ModelGeometryInfo::volume(*model,density));
}

void ModelGeometry::p_area(ExtValue *args,ExtValue *ret)
{
ret->setDouble(ModelGeometryInfo::area(*model,density));
}

void ModelGeometry::p_sizesandaxes(ExtValue *args,ExtValue *ret)
{
Pt3D sizes; Orient axes;
ModelGeometryInfo::findSizesAndAxesOfModel(*model,density,sizes,axes);
VectorObject* n=new VectorObject;
n->data+=new ExtValue(Pt3D_Ext::makeDynamicObject(sizes));
n->data+=new ExtValue(Orient_Ext::makeDynamicObject(new Orient_Ext(axes)));
ret->setObject(n->makeObject());
}
