// ///////////////////////////////////////////////////
// Computing angle between two vectors
function vectorsAngle(v1, v2)
{
  var x1 = v1[0];
  var y1 = v1[1];
  var l1 = Math.sqrt(x1 * x1 + y1 * y1);

  var x2 = v2[0];
  var y2 = v2[1];
  var l2 = Math.sqrt(x2 * x2 + y2 * y2);

  var vProduct = x1 * y2 - y1 * x2;
  var direction;

  if (vProduct >= 0)
    direction = 1.0;
  else
    direction = -1.0;

  var cosinus = (x1 * x2 + y1 * y2) / (l1 * l2);
  var angle = Math.acos(cosinus);

  print("Vector1: [" + x1 + ", " + y1 + "] Vector2: " + x1 + ", " + y1 + "] " +
        "Angle: " + (180.0 * angle / Math.pi) + " Direction: " + direction);

  return direction * angle;
}

// ///////////////////////////////////////////////////
// Computing rotated vector v1 by angle theta
function rotateVector(v1, theta)
{
  var x1 = v1[0];
  var y1 = v1[1];
  var x2 = x1 * Math.cos(inRads(theta)) -  y1 * Math.sin(inRads(theta));
  var y2 = x1 * Math.sin(inRads(theta)) +  y1 * Math.cos(inRads(theta));

  return [x2, y2];
}

// ///////////////////////////////////////////////////
// Convert degrees to radians
function inRads(degrees)
{
  return (Math.pi * degrees) / 180.0;
}

// ///////////////////////////////////////////////////
// Returns the index of the row containing given value in given column
// -1 if value was not found
function arrayContains(array, column, value)
{
  if (array == null) return -1;
  var i = 0;
  for (i = 0; i < array.size; i++)
  {
    if (array.get(i) != null)
      if (array.get(i).get(column) == value) return i;
  }
  return -1;
}