function Viewer() {
    this.Mode = {
        LINK: 0,
        EMBEDDED: 1,
        TEXTAREA: 2,
        CODE: 3
    };

    this._context = undefined;
    this._urlToXML = 'f0def.xml';//"http://www.framsticks.com/files/apps/config/f0def.xml";
    this._xml = undefined;
    this._model = new Model();
    this._part = new Part();
    this._joint = new Joint();
    this._neuro = new Neuro();
    this._neuroConn = new NeuroConn();
    this._parts = [];
    this._joints = [];
    this._neurons = [];
    this._neuroConns = [];
    this._neuroClasses = {};
    this._graphicsEngine = undefined;
    this._neuronDrawer = undefined;
    this.downloadXML();
    this.parseGeneXml();
    this.VisualizationSettings = {
        context: undefined,
        width: undefined,
        height: undefined
    };
    this.NetworkSettings = {
        context: undefined,
        width: undefined,
        height: undefined
    };
}

Viewer.prototype.downloadXML = function () {
    var local = this;
    $.ajax({
        url: local._urlToXML,
        dataType: "xml",
        async: false,
        success: function (xml) {
            var xmlDoc = $.parseXML(xml);
            $xml = $(xmlDoc);
            local._xml = $(xml);
        },
        error: function () {
            alert("Can't download file f0def.xml");
        }
    })
};

Viewer.prototype.parseGeneXml = function () {
    this._parseClass($(this._xml.find("CLASS")));
    this._parseNeuroClass($(this._xml.find("NEUROCLASS")))
};

Viewer.prototype._parseClass = function (nodes) {
    var local = this;

    nodes.each(function (entry) {
        var node = $(nodes[entry]);

        if (node.attr("NAME") == "Model") {
            local._model.setModel(node);
        }
        else if (node.attr("NAME") == "Part")
            local._part.setModel(node);
        else if (node.attr("NAME") == "Joint")
            local._joint.setModel(node);
        else if (node.attr("NAME") == "Neuro")
            local._neuro.setModel(node);
        else if (node.attr("NAME") == "NeuroConn")
            local._neuroConn.setModel(node);
        else {
            console.log("Could not recognize NAME:", node.attr("NAME"));
        }

    });
};

Viewer.prototype._parseNeuroClass = function (data) {

    for (var i = 0; i < data.length; i++) {
        var neuroClass = new NeuroClass();
        this._neuroClasses[data[i].attributes[0].value] = neuroClass;
        neuroClass.setModel(data);
    }

};

Viewer.prototype.analyseLine = function (line) {
    //ignore comment
    if (line[0] == '#' || line == "")
        return;

    var object;
    var type = line[0];
    if (type == "p") {
        object = $.extend(true, {}, this._part);
        this._parts.push(object);
    }
    else if (type == "j") {
        object = $.extend(true, {}, this._joint);
        this._joints.push(object);
    }
    else if (type == "n") {
        object = $.extend(true, {}, this._neuro);
        this._neurons.push(object);
    }
    else if (type == "c") {
        object = $.extend(true, {}, this._neuroConn);
        this._neuroConns.push(object);
    }
    else if (type == "m") {
        object = $.extend(true, {}, this._model);
        this._modelOne = object;
    }
    else
        throw new Error("Undefined element: \"" + type + "\"");

    //remove char and ":"
    line = line.substring(2);
    var lines = line.match(/([^,"]+|"[^"]+")+/g);

    if (lines != null)
        lines.forEach(function (value) {
            value = value.trim();
            if (value == "")
                object.setValue();
            else if (value.indexOf("=") == -1) {
                object.setValue(value);
            }
            else {
                var name = value.substring(0, value.indexOf("="));
                var val = value.substring(value.indexOf("=") + 1);
                object.setValue(name, val);
            }
        })
};

Viewer.prototype.getCreature = function (mode, content) {

    var lines = undefined;
    if (mode == this.Mode.LINK)
        lines = this._getCreatureFromLink(content);
    else if (mode == this.Mode.EMBEDDED)
        lines = this._getCreatureFromEmbeddedCode(content);
    else if (mode == this.Mode.TEXTAREA)
        lines = this._getCreatureFromTextArea(content);
    else if (mode == this.Mode.CODE)
        lines = this._getCreatureFromCode(content);
    else {
        throw "Wrong mode in function getCreature";
    }
    return lines;
};

Viewer.prototype._getCreatureFromLink = function (link) {
    var lines = undefined;
    $.ajax({
        url: link,
        async: false,
        dataType: "text",
        success: function (data) {
            lines = data.split("\n");

        },
        error: function () {
            alert("Can't download creature");
        }
    });
    return lines;
};

Viewer.prototype._getCreatureFromTextArea = function (area) {
    var lines = undefined;
    lines = area.val();
    lines = lines.split("\n");
    return lines;
};

Viewer.prototype._getCreatureFromCode = function (code) {
    var lines = code;
    lines = lines.split("\n");
    return lines;
};

Viewer.prototype._getCreatureFromEmbeddedCode = function (link) {
    var lines = undefined;

    $.ajax({
        url: link,
        async: false,
        dataType: "html",
        success: function (data) {
            var geno = $($(data).find("div")[0]).comments().html();
            geno = geno.replace("FRED_GEN", "");
            lines = geno.split("\n");
        },
        error: function () {
            alert("Can't download creature");
        }
    });

    return lines;
};

Viewer.prototype.parseCreature = function (mode, content) {
    var lines = this.getCreature(mode, content);
    lines.splice(0, 1);
    var local = this;
    lines.forEach(function (value) {
        local.analyseLine(value);
    });
};

Viewer.prototype.renderCreature = function () {

    if ($("#axisBox").is(":checked"))
        this._graphicsEngine.showPartAxis();

    for (var i = 0; i < this._parts.length; i++)
        this._graphicsEngine.addPart(this._parts[i])

    for (var i = 0; i < this._joints.length; i++) {
        this._graphicsEngine.addJoint(this._joints[i]);
    }

};

Viewer.prototype.run = function (mode, content) {
    this.parseCreature(mode, content);

    if (this.VisualizationSettings.context) {
        this._graphicsEngine = new GraphicsEngine(this.VisualizationSettings.context, this.VisualizationSettings.width, this.VisualizationSettings.height);
        this._graphicsEngine.initializeScene();
        this.renderCreature();
        this._graphicsEngine.debugTest();
        this._graphicsEngine.renderScene();
    }
    if (this.NetworkSettings.context) {
        this._neuronDrawer = new NeuronDrawer(this.NetworkSettings.context, this.NetworkSettings.width, this.NetworkSettings.height );
        this._neuronDrawer.initializeNewCanvas();
        new SmartLayout(this._neurons, this._neuroConns);
        this._neuronDrawer.drawNeuralNetwork(this._neurons, this._neuroConns, einfos, this._neuroClasses);
        this._neuronDrawer.finalize();

        /*this._neuronDrawer = new NeuronDrawer(this._neuronsContext);
        this._neuronDrawer.initializeScene();
        new SmartLayout(this._neurons, this._neuroConns);
        this._neuronDrawer.drawNeuralNetwork(this._neurons, this._neuroConns, einfos, this._neuroClasses);
        this._neuronDrawer.renderScene();*/
    }
}

function openTextAreaCreature() {
    var viewer = new Viewer();

    viewer.VisualizationSettings.context = $("#container");
    viewer.VisualizationSettings.width = 400;
    viewer.VisualizationSettings.height = 400;

    viewer.NetworkSettings.context =  "containerNeuron";
    viewer.NetworkSettings.width = 400;
    viewer.NetworkSettings.height = 400;
    viewer.run(viewer.Mode.TEXTAREA, $("#geno"));
}

function openEmbeddedCreature() {
    var viewer = new Viewer();
    viewer.VisualizationSettings.context = $("#container1");
    viewer.VisualizationSettings.width = 400;
    viewer.VisualizationSettings.height = 400;

    viewer.NetworkSettings.context =  "containerNeuron1";
    viewer.NetworkSettings.width = 400;
    viewer.NetworkSettings.height = 400;
    viewer.run(viewer.Mode.EMBEDDED, "http://ec.framsticks.com/www/index.php?PAGE=view_genotype&ID=55");
}

function openCodeCreature() {
    var viewer = new Viewer();
    viewer.VisualizationSettings.context = $("#container2");
    viewer.VisualizationSettings.width = 400;
    viewer.VisualizationSettings.height = 400;
    viewer.NetworkSettings.context =  "containerNeuron2";
    viewer.NetworkSettings.width = 400;
    viewer.NetworkSettings.height = 400;
    viewer.run(viewer.Mode.CODE, "//0\np:\np: x=1");
}

function openFileCreature() {
    var viewer = new Viewer();
    //var debugCreatureName = "example4";
    //var debugCreatureName = "caterpillar";
    //var debugCreatureName = "Quadro";
    var debugCreatureName = "spider";
    //viewer.VisualizationSettings.context = $("#container3");
    //viewer.VisualizationSettings.width = 400;
    //viewer.VisualizationSettings.height = 400;
    viewer.NetworkSettings.context =  "containerNeuron3";
    //viewer.NetworkSettings.width = 400;
    //viewer.NetworkSettings.height = 400;
    viewer.run(viewer.Mode.LINK, "http://localhost:63343/FramestickFavi/creatures/" + debugCreatureName + ".txt");
}