// This file is a part of the Framsticks GDK.
// Copyright (C) 1999-2014  Maciej Komosinski and Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.framsticks.com/ for further information.

#include "genotypeloader.h"

/**
 @file
 Sample code: Loading genotypes from Framsticks files

 \include loader_test.cpp
*/

int main(int argc,char*argv[])
{
if (argc<2)
	{
	fprintf(stderr,"Arguments: filename [optional: genotype name or index (1-based)]\n"
	     "If a genotype is indicated (by providing the optional genotype identifier), the program will output the raw genotype, suitable for Framsticks Theater's genotype viewer mode. If the second optional argument is not given, the genotype names from the file will be listed.\n"
	     "Example: loader_test walking.gen \"Basic Quadruped\" | theater -g -\n"
		);
	return 1;
	}

long count=0,totalsize=0;
MiniGenotypeLoader loader(argv[1]);
const char* selected=(argc<3)?NULL:argv[2];
int selected_index=(selected&&isdigit(selected[0]))?atol(selected):0;
// using char* constructor (passing the file name to open)
MiniGenotype *loaded;
while(loaded=loader.loadNextGenotype())
	{ // if loaded != NULL then the "org:" object data was
	 // loaded into MiniGenotype object
	count++;
	totalsize+=loaded->genotype.len();
	if (selected)
		{
		if (selected_index)
			{
			if (selected_index!=count)
				continue;
			}
		else
			{
			if (strcmp((const char*)loaded->name,selected))
				continue;
			}
		puts((const char*)loaded->genotype);
		return 0;
		}
	fprintf(stderr,"%d. %s\t(%d characters)\n",count,(const char*)loaded->name,loaded->genotype.len());
	}
// the loop repeats until loaded==NULL, which could be beacause of error
if (loader.getStatus()==MiniGenotypeLoader::OnError)
	fprintf(stderr,"Error: %s",(const char*)loader.getError());
// (otherwise it was the end of the file)
if (selected)
	{
	fprintf(stderr,"genotype %s not found in %s\n",selected,argv[1]);
	return 2;
	}
else
	{
	fprintf(stderr,"\ntotal: %d items, %d characters\n",count,totalsize);
	return 0;
	}
}
