// This file is a part of the Framsticks GDK.
// Copyright (C) 1999-2014  Maciej Komosinski and Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.framsticks.com/ for further information.

#include "genotypeloader.h"

#define FIELDSTRUCT MiniGenotype
ParamEntry minigenotype_paramtab[]=
 {
 {"Genotype",1,3,"org",},
 {"name",0,0,"Name","s 0 40",FIELD(name),},
 {"genotype",0,0,"Genotype","s 1",FIELD(genotype),},
 {"info",0,0,"Info","s 1",FIELD(info),},
 {0,0,0,},
};
#undef FIELDSTRUCT

MiniGenotypeLoader::MiniGenotypeLoader():genotype_param(minigenotype_paramtab,&genotype_object) {init();}
MiniGenotypeLoader::MiniGenotypeLoader(VirtFILE *f):MultiParamLoader(f),genotype_param(minigenotype_paramtab,&genotype_object) {init();}
MiniGenotypeLoader::MiniGenotypeLoader(const char* filename):MultiParamLoader(filename),genotype_param(minigenotype_paramtab,&genotype_object) {init();}

void MiniGenotypeLoader::init()
{
addObject(&genotype_param);
breakOn(MultiParamLoader::OnError + MultiParamLoader::AfterObject);
}

MiniGenotype* MiniGenotypeLoader::loadNextGenotype()
{
genotype_object.clear();
if ((go()==AfterObject)&&(getObject().matchesInterfaceName(&genotype_param)))
	return &genotype_object;
else
	return 0;
}
