// This file is a part of the Framsticks GDK.
// Copyright (C) 1999-2014  Maciej Komosinski and Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.framsticks.com/ for further information.

#include <frams/errmgr/stdouterr.h>
#include <frams/genetics/preconfigured.h>

void printGen(Geno &g)
{
	printf("Genotype: %s\nFormat: %c\nValid: %s\nComment: %s\n",
		(const char*)g.getGene(), g.getFormat(), g.isValid() ? "yes" : "no", g.getComment().len() == 0 ? "(empty)" : (const char*)g.getComment());
}

void printGenAndTitle(Geno &g, const char* title)
{
	printf("\n--------------------- %s: ---------------------\n", title);
	printGen(g);
}

/* Demonstrates various genetic operators applied to a sample genotype. See also oper_fx.cpp. */
int main(int argc, char *argv[])
{
	StdoutErrorHandler err;//the default ErrorHandler constructor automatically registers this object to receive framsg messages (and in this case, redirect them to standard output)
	PreconfiguredGenetics genetics;

	rndGetInstance().randomize();
	genetics.genman.p_report(NULL, NULL);

	const char* src = (argc > 1) ? argv[1] : "/*9*/UUU";
	Geno gsrc(src, -1, "First");
	printGenAndTitle(gsrc, "source genotype (gsrc)");
	char format = gsrc.getFormat();

	Geno gmut = genetics.genman.Mutate(gsrc);
	printGenAndTitle(gmut, "mutated (gmut)");

	Geno gxover = genetics.genman.CrossOver(gsrc, gmut);
	printGenAndTitle(gxover, "crossed over (gsrc and gmut)");

	Geno gsimplest = genetics.genman.GetSimplest(format);
	printGenAndTitle(gsimplest, "simplest");

	Geno ginvalid("IT'S REALLY WRONG", format);
	printGenAndTitle(ginvalid, "invalid");

	Geno gvalidated = genetics.genman.Validate(ginvalid);
	printGenAndTitle(gvalidated, "validated");

	printf("\nHTMLized: %s\n", (const char*)genetics.genman.HTMLize((const char*)gvalidated.getGene()));

	return 0;
}
