// This file is a part of the Framsticks GDK.
// Copyright (C) 1999-2014  Maciej Komosinski and Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.framsticks.com/ for further information.

#include <frams/virtfile/stdiofile.h>
#include <frams/util/sstringutils.h>
#include <frams/genetics/preconfigured.h>

/**
 @file
 Sample code: Testing genotype validity

 \include geno_test.cpp
*/

int main(int argc,char*argv[])
{
PreconfiguredGenetics genetics;

if (argc<=1)
	{
	puts("no genotype");
	return 10;
	}
SString gen(argv[1]);
if (!strcmp(gen,"-"))
	{
	gen=0;
	StdioFILEDontClose in(stdin);
	loadSString(&in,gen);
	}
Geno g(gen);
puts(g.isValid()?"valid":"invalid");
return !g.isValid();
}
