var neuroSL = null;
var neuroConnSL = null;

var einfos = [];
var blocks = [];

var N = null;

function SmartLayout(neu, con)
{
    neuroSL = neu;
    neuroConnSL = con;
    N = neuroSL.length;

    /////////////////////////
    //////Faza pierwsza//////
    /////////////////////////
    blocks = new Array(N);
    for(var i = 0; i < N; i++){
        einfos.push(new einfo())
    }

    for(var i = 0; i < N; i++)
        setElement(i);

    /////////////////////////
    //////Faza druga/////////
    /////////////////////////

    var first = null;
    var el;
    for(el = 0; el < N; el++){
        if(blocks[el]){
            first = blocks[el];
            el++;
            break;
        }
    }

    while(el < N){
        if((first.maxx - first.minx) > (first.maxy - first.miny)){
            var y = first.maxy + 2;
            var x = first.minx;
            var ex = first.maxx;
            while (el<N)
            {
                if (blocks[el])
                {
                    var dx = blocks[el].maxx - blocks[el].minx + 2;
                    merge(first, blocks[el], x - blocks[el].minx, y - blocks[el].miny);
                    x += dx;
                    if (x > ex)
                        break;
                }
                el++;
            }
        }
        else
        {
            var x = first.maxx + 2;
            var y = first.miny;
            var ey = first.maxy;
            while (el<N)
            {
                if (blocks[el])
                {
                    var dy = blocks[el].maxy - blocks[el].miny + 2;
                    merge(first, blocks[el], x - blocks[el].minx, y - blocks[el].miny);
                    y += dy;
                    if (y > ey)
                        break;
                }
                el++;
            }
        }
        }

    //Pokazanie wartości
    if (first) // at this stage we have a single block containing all neurons
    {
        console.log(" - - setting coordinates - -\n");
        var i;
        first.createMap();
        for (i = 0; i < first.elements.length; i++)
        {
            el = first.elements[i];
            console.log(el, einfos[el].x * 70, -1 * einfos[el].y * 70);
        }
        delete first;
    }

}

function einfo(){
    this.block = null;
    this.x = null;
    this.y = null;
}

function Block(number){
    this.id = number;
    this.elements = [];
    this.w = 1;
    this.h = 1;
    this.minx = 0;
    this.miny = 0;
    this.maxx = 0;
    this.maxy = 0;
    this.addElement(number,0, 0);
    blocks[this.id] = this;
    this.map = [];
}

Block.prototype.destroy = function()
{
    blocks[this.id] = 0;
    this.freeMap();
}

Block.prototype.freeMap = function(){
    if(this.map)
        this.map = [];
}

Block.prototype.needMap = function(){
    if(this.map)
        return;
    this.createMap();

}

Block.prototype.createMap = function(){
    this.freeMap();
    this.w = this.maxx - this.minx + 1;
    this.h = this.maxy - this.miny + 1;
    for(var i = 0; i < this.w * this.h; i++)
        this.map.push(0);

    for (var i = 0; i < this.elements.length; i++)
    {
        var e = this.elements[i];
        this.map[this.w*(einfos[e].y - this.miny) + (einfos[e].x - this.minx)] = 1;
    }
}

Block.prototype.addElement = function(number, x, y){
    this.elements.push(number);
    einfos[number].x = x;
    einfos[number].y = y;
    einfos[number].block = this;
}

function canMerge(block, block2, dx, dy){
    var x1, y1, x2, y2;

    x1 = Math.max(0, block2.minx - block.minx + dx);
    x2 = Math.min(block.maxx - block.minx, -block.minx + dx + block2.maxx);
    if (x1 > x2)
        return 1;


    y1 = Math.max(0, block2.miny - block.miny + dy);
    y2 = Math.min(block.maxy - block.miny, -block.miny + dy + block2.maxy);
    if (y1 > y2)
        return 1;


    var x, y;
    dx += block2.minx - block.minx; //dx,dy relative to minx,miny
    dy += block2.miny - block.miny;

    block.createMap();
    block2.createMap();

    for (y = y1; y <= y2; y++)
    {
        for (x = x1; x <= x2; x++)
            if (block.map[block.w * y + x] && block2.map[block2.w * (y - dy) + (x - dx)])
                return 0;
    }
    return 1;

}

function merge(block, block2, dx, dy){

    if(!canMerge(block, block2, dx, dy))
        return 0;

    block.freeMap();


    for (var i = 0; i < block2.elements.length; i++)
    {
        var e = block2.elements[i];
        block.addElement(e, einfos[e].x + dx, einfos[e].y + dy);
    }

    block.minx = Math.min(block.minx, dx + block2.minx);
    block.miny = Math.min(block.miny, dy + block2.miny);
    block.maxx = Math.max(block.maxx, dx + block2.maxx);
    block.maxy = Math.max(block.maxy, dy + block2.maxy);


    block2.destroy();
    delete block2;
    return 1;

}

function connectAsInput(e, e2){
    var b, b2;

    b = einfos[e].block;


    if (!einfos[e2].block)
        new Block(e2);

    b2 = einfos[e2].block;

    if (b == b2)
    {
        return;
    }
    var dx, dy;
    dx = einfos[e].x - einfos[e2].x;
    dy = einfos[e].y - einfos[e2].y;

    if (merge(b, b2, dx - 1, dy))
        return;

    for (var proba = 1;; proba++)
    {
        if (merge(b, b2, dx - 1, dy - proba))
            return;
        if (merge(b, b2, dx - 1, dy + proba))
            return;
    }
}

function setElement(e){
    if (einfos[e].block != null)
    {
        return;
    }

    new Block(e);
    //trzeba pobrać elementy
    var n = getNumOfInCon(e);
    for (var we = 0; we < n; we++)
    {
        var e2 = getLink(e, we);
        if (e2 < 0)
            continue;
        if (e == e2)
            continue;
        setElement(e2);
        connectAsInput(e, e2);
    }
}

function getNumOfInCon(nr){
    var number = 0;
    for(var i = 0;  i < neuroConnSL.length; i++){
        if(neuroConnSL[i].getDestination() == nr)
            number++;
    }
    return number;
}

function getLink(destination, number){
    var temp = 0;
    for(var i = 0; i < neuroConnSL.length; i++){
        if(neuroConnSL[i].getDestination() == destination){

            if(temp == number)
                return neuroConnSL[i].getSource();
            else
                temp++;
        }
    }
}