package com.framsticks.test.prime;

import static org.fest.assertions.Assertions.*;

import java.util.Arrays;
import java.util.List;

import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import com.framsticks.params.AccessOperations;
import com.framsticks.params.FramsClass;
import com.framsticks.params.ListSink;
import com.framsticks.params.ListSource;
// import com.framsticks.params.ListSource;
import com.framsticks.params.Registry;
import com.framsticks.params.types.ObjectParam;
import com.framsticks.test.TestConfiguration;

@Test
public class PrimePackageTest extends TestConfiguration {

	Registry registry;

	protected final List<String> printedPrimePackage = Arrays.asList(
		"ExpParams:",
		"from_number:100",
		"to_number:200",
		"",
		"ExpState:",
		"current_number:201",
		"result:@Serialized:[151,157,163,167,173,179,181,191,193,197,199]",
		""
	);

	@BeforeClass
	public void setupRegistry() {
		registry = new Registry();
		registry.registerAndBuild(PrimePackage.class);
	}

	@Test
	public void primePackageFramsClass() {
		FramsClass framsClass = registry.getFramsClassForJavaClass(PrimePackage.class);
		assertThat(framsClass).isNotNull();
		assertThat(framsClass.getParamCount()).isEqualTo(2);
		assertThat(framsClass.getParam(0)).isInstanceOf(ObjectParam.class);
		assertThat(framsClass.getParam(1)).isInstanceOf(ObjectParam.class);
	}

	@Test(dependsOnMethods = "primePackageFramsClass")
	public void printPrimePackage() {
		PrimePackage primePackage = new PrimePackage();
		primePackage.params.from_number = 100;
		primePackage.params.to_number = 200;

		primePackage.state.current_number = 201;
		primePackage.state.getResultList().addAll(Arrays.asList(151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199));

		// assertThat(primePackage.state.getResult()).isEqualTo("@Serialized[151,157,163,167,173,179,181,191,193,197,199]");

		ListSink sink = new ListSink();

		AccessOperations.saveAll(registry.createAccess(PrimePackage.class).select(primePackage), sink, registry);

		assertThat(sink.getOut()).isEqualTo(printedPrimePackage);
	}

	@Test(dependsOnMethods = "printPrimePackage")
	public void loadPrimePackage() {

		// PrimePackage primePackage = new PrimePackage();

		ListSource source = new ListSource(printedPrimePackage);

		Object result = AccessOperations.loadAll(registry.createAccess(PrimePackage.class), source, registry).getSelected();
		assertThat(result).isInstanceOf(PrimePackage.class);
		PrimePackage primePackage = (PrimePackage) result;

		assertThat(primePackage.params.from_number).isEqualTo(100);
		assertThat(primePackage.params.to_number).isEqualTo(200);

		assertThat(primePackage.state.current_number).isEqualTo(201);
		assertThat(primePackage.state.getResultList()).isEqualTo(Arrays.asList(151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199));

	}
}
