package com.framsticks.standard;

import java.util.List;
import java.util.Map;

import org.testng.annotations.Test;

import com.framsticks.model.Genotype;
import com.framsticks.params.Access;
import com.framsticks.params.AccessOperations;
import com.framsticks.params.FramsClass;
import com.framsticks.params.FreeObject;
import com.framsticks.params.ListSink;
import com.framsticks.params.PropertiesAccess;
import com.framsticks.params.PropertiesObject;
import com.framsticks.params.ReflectionAccess;
import com.framsticks.params.Registry;
import com.framsticks.params.types.UniqueListParam;
import com.framsticks.test.TestConfiguration;
import static org.fest.assertions.Assertions.*;

@Test
public class StandardStateTest extends TestConfiguration {


	protected final Registry registry = new Registry();
	protected Access stateAccess;

	@Test
	public void testLoad() {
		registry.registerAndBuild(StandardState.class);

		FramsClass stateFramsClass = registry.getFramsClassForJavaClass(StandardState.class);
		assertThat(stateFramsClass.getParamCount()).isEqualTo(3);
		assertThat(registry.getFramsClass("GenePool").getParam("genotypes")).isInstanceOf(UniqueListParam.class);

		stateAccess = AccessOperations.loadAll(registry.createAccess(StandardState.class), getSource("/netfiles/standard.expt"), registry);
		assertThat(stateAccess.getTypeId()).isEqualTo("StandardState");

		assertThat(stateAccess.getSelected()).isInstanceOf(StandardState.class);
		StandardState state = (StandardState) stateAccess.getSelected();

		assertThat(state.simParams).isInstanceOf(FreeObject.class);
		FreeObject simParams = (FreeObject) state.simParams;
		assertThat(simParams.get("Energy0", Double.class)).isEqualTo(5000.0);

		assertThat(state.genepools.size()).isEqualTo(1);
		assertThat(state.populations.size()).isEqualTo(2);

		assertThat(state.genepools.get(0)).isInstanceOf(PropertiesObject.class);

		Access genePoolAccess = registry.bindAccessFor(state.genepools.get(0));
		assertThat(genePoolAccess).isInstanceOf(PropertiesAccess.class);
		assertThat(genePoolAccess.get("fitness", String.class)).isEqualTo("return 0.0+this.velocity*1.0;");
		assertThat(genePoolAccess.get("genotypes", Object.class)).isInstanceOf(Map.class);
		assertThat(genePoolAccess.get("genotypes", Object.class)).isInstanceOf(Map.class);

		Access genotypesAccess = registry.bindAccessFor(genePoolAccess, "genotypes");
		assertThat(genotypesAccess.getParamCount()).isEqualTo(3);

		Access genotypeAccess = registry.bindAccessFor(genotypesAccess, "0");
		assertThat(genotypeAccess).isInstanceOf(ReflectionAccess.class);
		assertThat(genotypeAccess.getSelected()).isInstanceOf(Genotype.class);

		Genotype genotype = (Genotype) genotypeAccess.getSelected();
		assertThat(genotype.name).isEqualTo("Uwuwit Si");
	}

	@Test
	public void testSave() {
		List<String> out = AccessOperations.saveAll(stateAccess, new ListSink(), registry).getOut();
		assertThat(out).contains("Genotype:", "name:Uwuwit Si");
		// for (String l : out) {
		// 	System.out.println(l);
		// }
	}


}
