package com.framsticks.params;

import org.testng.annotations.Test;

import com.framsticks.params.types.FloatParam;
import com.framsticks.params.types.StringParam;
import com.framsticks.parsers.AccessStash;
import com.framsticks.parsers.MultiParamLoader;
import com.framsticks.test.TestConfiguration;
import static org.fest.assertions.Assertions.*;
import static com.framsticks.params.ParamsUtil.getParam;

@Test
public class ParamBuilderTest extends TestConfiguration {

	ParamBuilder builder;
	FramsClass builderFramsClass;
	Access access;

	@Test
	public void createBuilderFramsClass() {
		builderFramsClass = FramsClass.build().forClass(ParamBuilder.class);

		assertThat(builderFramsClass.getParamCount()).isEqualTo(10);
		assertThat(builderFramsClass.getName()).isEqualTo("prop");
		assertThat(builderFramsClass.getId()).isEqualTo("prop");
		assertThat(getParam(builderFramsClass, "flags", ValueParam.class).getDef(Object.class)).isEqualTo(new Integer(0));
		assertThat(getParam(builderFramsClass, "id", Param.class)).isInstanceOf(StringParam.class);
	}

	@Test(dependsOnMethods = { "createBuilderFramsClass" })
	public void loadParam() throws Exception {
		access = new ReflectionAccess(ParamBuilder.class, builderFramsClass);
		Source source = ListSource.createFrom("prop:", "id:v", "name:variable", "type:f", "help:just a testing variable", "");

		MultiParamLoader loader = new MultiParamLoader();
		loader.setNewSource(source);
		loader.setAccessProvider(new AccessStash().add(access));
		loader.addBreakCondition(MultiParamLoader.Status.AfterObject);

		MultiParamLoader.Status status = loader.go();

		assertThat(status).isEqualTo(MultiParamLoader.Status.AfterObject);
		Object object = loader.returnObject();
		assertThat(object).isInstanceOf(ParamBuilder.class);

		builder = (ParamBuilder) object;

		Param param = builder.finish();
		assertThat(param).isInstanceOf(FloatParam.class);
	}

}
