package com.framsticks.params;

import static org.fest.assertions.Assertions.*;

import java.util.Arrays;
import java.util.List;

import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import com.framsticks.test.TestClass;
import com.framsticks.test.TestConfiguration;
import static com.framsticks.params.AccessOperations.*;

@Test
public class AccessOperationsTest extends TestConfiguration {

	Registry registry;

	TestClass testObject;

	List<String> printResult;

	List<String> printed = Arrays.asList(
		"TestClass:",
		"name:just a test",
		"history:a very, very long history...",
		"",
		"TestChild:",
		"name:first child",
		"uid:c0",
		"",
		"TestChild:",
		"name:second child",
		"uid:c1",
		""
	);

	@BeforeClass
	public void setUp() {
		registry = new Registry();
		registry.registerAndBuild(TestClass.class);

		testObject = new TestClass();
		testObject.setName("just a test");
		testObject.setHistory("a very, very long history...");

		testObject.createChild("first child");
		testObject.createChild("second child");
	}

	@Test
	public void testEquals() {
		assertThat(areEqual(registry.bindAccessFor(testObject), registry.bindAccessFor(testObject), registry)).isTrue();
	}

	@Test
	public void testSaveAll() {

		ListSink sink = new ListSink();
		saveAll(registry.bindAccessFor(testObject), sink, registry);
		printResult = sink.getOut();

		assertThat(printResult).isEqualTo(printed);
	}

	@Test
	public void testLoadAll() {
		TestClass testLoad = new TestClass();
		loadAll(registry.bindAccessFor(testLoad), new ListSource(printed), registry);
		assertThat(areEqual(registry.bindAccessFor(testLoad), registry.bindAccessFor(testObject), registry)).isTrue();

		ListSink sink = new ListSink();
		saveAll(registry.bindAccessFor(testLoad), sink, registry);

		assertThat(sink.getOut()).isEqualTo(printed);
	}

}
