package com.framsticks.model.f0;

import org.testng.annotations.*;

import com.framsticks.params.FramsClass;
import com.framsticks.params.types.FloatParam;
import com.framsticks.test.TestConfiguration;
import com.framsticks.model.f0.Schema;

import static org.fest.assertions.Delta.*;

import static org.fest.assertions.Assertions.*;
import static com.framsticks.params.ParamsUtil.getParam;

public class SchemaTest extends TestConfiguration {

	@Test
	public void loadSchemaWithXmlLoader() {
		Schema schema = new SchemaBuilder().stream(Schema.getDefaultDefinitionAsStream()).finish();
		assertThat(schema.getFramsClasses().size()).isEqualTo(5);
		assertThat(schema.getNeuroClasses().size()).isEqualTo(21);

		assertThat(schema.getFramsClass("m").getName()).isEqualTo("Model");

		assertThat(schema.getNeuroClass("|").getName()).isEqualTo("Bend muscle");
		assertThat(getParam(schema.getNeuroClass("VEye"), "p")).isInstanceOf(FloatParam.class);
		assertThat(getParam(schema.getNeuroClass("VEye"), "p", FloatParam.class).getMax(Double.class)).isEqualTo(10.0, delta(0.0));

		FramsClass partClass = schema.getFramsClass("p");
		assertThat(partClass).isNotNull();
		assertThat(getParam(partClass, "as", FloatParam.class).getDef(Double.class)).isEqualTo(0.25, delta(0.0));
		assertThat(partClass.getGroupCount()).isEqualTo(3);
		assertThat(partClass.getGroup(1).getName()).isEqualTo("Other properties");
		assertThat(partClass.getGroup(1).getCount()).isEqualTo(7);
		assertThat(partClass.getGroup(1).getParam(2)).isEqualTo(partClass.getParam("dn"));
	}

}
