package com.framsticks.model;

import org.testng.annotations.Test;

import com.framsticks.params.FramsClass;
import com.framsticks.params.ReflectionAccess;
import com.framsticks.params.types.ArrayListParam;
import com.framsticks.params.types.DecimalParam;
import com.framsticks.params.types.StringParam;
import com.framsticks.test.TestConfiguration;

import static org.fest.assertions.Assertions.*;
import static com.framsticks.params.ParamsUtil.getParam;

@Test
public class CreatureTest extends TestConfiguration {

	FramsClass framsClass;
	ArrayListParam partsParam;
	ReflectionAccess access;
	Creature creature;

	@Test
	public void testFramsClass() {
		framsClass = FramsClass.build().forClass(Creature.class);

		assertThat(framsClass).describedAs("framsClass").isNotNull();
		assertThat(framsClass.getParam("name")).describedAs("name").isInstanceOf(StringParam.class);
		assertThat(framsClass.getParam("parts")).describedAs("parts").isInstanceOf(ArrayListParam.class);
		partsParam = getParam(framsClass, "parts", ArrayListParam.class);
		assertThat(partsParam).describedAs("partsParam").isNotNull();
		assertThat(partsParam).isInstanceOf(ArrayListParam.class);
		assertThat(partsParam.getContainedTypeName()).isEqualTo("Part");
		assertThat(framsClass.getParam("gnum")).isInstanceOf(DecimalParam.class);
	}

	@Test(dependsOnMethods = "testFramsClass")
	public void testReflectionAccess() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
		access = new ReflectionAccess(Creature.class, framsClass);
		Object object = access.createAccessee();
		assertThat(object).isInstanceOf(Creature.class);
		access.select(object);

		creature = (Creature) object;
		access.set("gnum", new Integer(1));
		// Creature.class.getField("generation").set(creature, 1);
		assertThat(creature.generation).isEqualTo(1);


	}



}
