package com.framsticks.gui.console;

import org.testng.annotations.Test;

import com.framsticks.gui.GuiTest;
import com.framsticks.remote.RemoteTree;
import com.framsticks.structure.Path;
import com.framsticks.util.dispatching.Dispatching;
import com.framsticks.util.dispatching.Dispatching.Waiter;
import com.framsticks.util.dispatching.Future;
import com.framsticks.util.dispatching.Joinable;
import com.framsticks.util.dispatching.JoinableCollection;

import static com.framsticks.structure.TreeOperations.*;

@Test
public class TrackConsoleTest extends GuiTest {

	RemoteTree tree;
	TrackConsole console;
	JoinableCollection<Joinable> joinables;

	@Override
	protected Joinable createSubject() {
		tree = new RemoteTree();

		tree.setAddress("localhost:9009");

		console = new TrackConsole().setConnection(tree.getConnection());
		joinables = new JoinableCollection<>();
		joinables.setObservableName("tree and console");
		joinables.add(tree);
		joinables.add(console);

		return joinables;
	}

	@Test
	public void testCommunication() {
		Dispatching.sleep(2.0);
		final Waiter waiter = produceWaiter(1.0);

		tryGet(tree, "/simulator/genepools/groups/0", new Future<Path>(failOnException) {

			@Override
			protected void result(Path result) {
				waiter.pass();

			}
		});
		Dispatching.sleep(2.0);
	}

	@Test(dependsOnMethods = "testCommunication")
	public void justWait() {
		Dispatching.sleep(2.0);
	}
}
