package com.framsticks.core;

import java.io.InputStream;

import org.testng.annotations.Test;

import com.framsticks.core.Framsticks;
import com.framsticks.test.MonitorBasedTest;
import com.framsticks.util.dispatching.Joinable;

// import static org.fest.assertions.Assertions.*;

@Test
public abstract class XmlBasedTest extends MonitorBasedTest {

	protected Framsticks framsticks;

	@Override
	protected Joinable createSubject() {
		framsticks = Framsticks.loadConfiguration(getConfigurationStream());
		return framsticks;
	}

	protected InputStream getConfigurationStream() {
		return XmlBasedTest.class.getResourceAsStream("/configs/" + getConfigurationName());
	}

	protected String getConfigurationName() {
		return this.getClass().getSimpleName() + ".xml";
	}


}
