package com.framsticks.core;

import java.io.InputStream;

import org.testng.annotations.Test;

import com.framsticks.gui.Browser;
import com.framsticks.test.TestConfiguration;

import static org.fest.assertions.Assertions.*;

@Test
public class FramsticksTest extends TestConfiguration {

	@Test
	public void testConfiguration() {
		InputStream stream = FramsticksTest.class.getResourceAsStream("/configs/test.xml");
		assertThat(stream).isNotNull();

		Framsticks framsticks = Framsticks.loadConfiguration(stream);
		assertThat(framsticks).isNotNull();
		assertThat(framsticks.size()).isEqualTo(1);
		assertThat(framsticks.get("browser")).isInstanceOf(Browser.class);
	}

}
