package com.framsticks.visualization;

import com.sun.j3d.utils.universe.*;
import com.sun.j3d.utils.geometry.ColorCube;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

import javax.media.j3d.*;
import javax.swing.*;
import javax.vecmath.*;
import java.awt.*;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

/**
 * Author: Piotr Śniegowski
 */
@SuppressWarnings("serial")
public class ViewerTest extends JPanel {
	private static final Logger log = LogManager.getLogger(ViewerTest.class.getName());

	private SimpleUniverse univ = null;
	private BranchGroup scene = null;

	public BranchGroup createSceneGraph() {
		// Create the root of the branch graph
		BranchGroup objRoot = new BranchGroup();

		// Create the TransformGroup node and initialize it to the
		// identity. Enable the TRANSFORM_WRITE capability so that
		// our behavior code can modify it at run time. Add it to
		// the root of the subgraph.
		TransformGroup objTrans = new TransformGroup();
		objTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		objRoot.addChild(objTrans);

		// Create a simple Shape3D node; add it to the scene graph.
		objTrans.addChild(new ColorCube(0.4));

		// Create a new Behavior object that will perform the
		// desired operation on the specified transform and add
		// it into the scene graph.
		Transform3D yAxis = new Transform3D();
		Alpha rotationAlpha = new Alpha(-1, 4000);

		RotationInterpolator rotator =
				new RotationInterpolator(rotationAlpha, objTrans, yAxis,
						0.0f, (float) Math.PI * 2.0f);
		BoundingSphere bounds =
				new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
		rotator.setSchedulingBounds(bounds);
		objRoot.addChild(rotator);

		// Have Java 3D perform optimizations on this scene graph.
		objRoot.compile();

		return objRoot;
	}

	private Canvas3D createUniverse() {
		// Get the preferred graphics configuration for the default screen
		GraphicsConfiguration config =
				SimpleUniverse.getPreferredConfiguration();

		// Create a Canvas3D using the preferred configuration
		final Canvas3D c = new Canvas3D(config) {
			@Override
			public void paint(Graphics graphics) {
				super.paint(graphics);
				Toolkit.getDefaultToolkit().sync();
			}

			@Override
			public void postRender() {
				super.postRender();
				//log.info("postRender()");
			}
			@Override
			public void postSwap() {
				super.postSwap();
				//log.info("postSwap()");
			}
		};


		c.addComponentListener(new ComponentListener() {
			@Override
			public void componentResized(ComponentEvent componentEvent) {
			}

			@Override
			public void componentMoved(ComponentEvent componentEvent) {
			}

			@Override
			public void componentShown(ComponentEvent componentEvent) {
				log.info("shown");
				c.startRenderer();
			}

			@Override
			public void componentHidden(ComponentEvent componentEvent) {
				log.info("hidden");
				c.stopRenderer();
			}
		});

		// Create simple universe with view branch
		univ = new SimpleUniverse(c);

		// This will move the ViewPlatform back a bit so the
		// objects in the scene can be viewed.
		univ.getViewingPlatform().setNominalViewingTransform();

		// Ensure at least 5 msec per frame (i.e., < 200Hz)
		univ.getViewer().getView().setMinimumFrameCycleTime(16);

		return c;
	}

	public ViewerTest() {

		this.setLayout(new java.awt.BorderLayout());

		this.setPreferredSize(new java.awt.Dimension(250, 250));

		Canvas3D c = createUniverse();
		c.setSize(100, 100);
		this.add(c, java.awt.BorderLayout.CENTER);

		// Create the content branch and add it to the universe
		scene = createSceneGraph();
		univ.addBranchGraph(scene);
	}
}
