package com.framsticks.util.swing;

import javax.swing.*;

/**
 * Author: Piotr Śniegowski
 */
public class MenuConstructor {
	protected final JMenu menu;

	public MenuConstructor(JMenu menu) {
		this.menu = menu;
	}

	public MenuConstructor add(KeyStroke accelerator, Action action) {
		JMenuItem item = new JMenuItem(action);
		if (accelerator != null) {
			item.setAccelerator(accelerator);
		}
		menu.add(item);
		return this;
	}

}
