package com.framsticks.util.swing;

import javax.swing.*;

/**
 * Author: Piotr Śniegowski
 */
public class KeyboardModifier {
	final InputMap inputMap;
	final ActionMap actionMap;

	public KeyboardModifier(JComponent component, int condition) {
		inputMap = component.getInputMap(condition);
		actionMap = component.getActionMap();
	}

	public KeyboardModifier join(KeyStroke newOne, KeyStroke oldOne) {
		inputMap.put(newOne, inputMap.get(oldOne));
		return this;
	}

	public KeyboardModifier add(KeyStroke keyStroke, String name, Action action) {
		inputMap.put(keyStroke, name);
		actionMap.put(name, action);
		return this;
	}
}
