package com.framsticks.util.math;
	
/**
 * The simple class which represent point in 3d space.
 */
public class Point3d
{
	public final double x;
	public final double y;
	public final double z;

	public Point3d() {
		x = 0.0;
		y = 0.0;
		z = 0.0;
	}

	public Point3d(double x, double y, double z) {
		this.x = x;
		this.y = y;
		this.z = z;
	}

	public Point3d(Point3d p) {
		x = p.x;
		y = p.y;
		z = p.z;
	}

	@Override
	public final String toString() {
		return x + " " + y + " " + z;
	}

	public final double get(int i) {
		switch (i) {
			case 0: return x;
			case 1: return y;
			case 2: return z;
		}
		assert false;
		return 0;
	}


	public final Point3d add(Point3d p) {
		return new Point3d(x + p.x, y + p.y, z + p.z);
	}

	public final Point3d sub(Point3d p) {
		return new Point3d(x - p.x, y - p.y, z - p.z);
	}

	public final double length() {
		return Math.sqrt(x * x + y * y + z * z);
	}

	public static class Builder {
		double[] a = new double[3];

		public Point3d build() { return new Point3d(a[0], a[1], a[2]); }

		public final void set(int i, double v) {
			a[i] = v;
		}
	}
}