package com.framsticks.util.lang;

/**
 * @author Piotr Sniegowski
 */
public class Pair<T1, T2> {
	public final T1 first;
	public final T2 second;

	public Pair(T1 first, T2 second) {
		this.first = first;
		this.second = second;
	}

	@Override
	public String toString() {
		return Strings.toStringNullProof(first) + " : " + Strings.toStringNullProof(second);
	}

	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof Pair)) {
			return false;
		}
		Pair<?, ?> p = (Pair<?, ?>) obj;
		return first.equals(p.first) && second.equals(p.second);
	}

	@Override
	public int hashCode() {
		return (first != null ? first.hashCode() : 0) ^ (second != null ? second.hashCode() : 0);
	}

	public static <U1, U2> Pair<U1, U2> make(U1 first, U2 second) {
		return new Pair<U1, U2>(first, second);
	}

}
