package com.framsticks.util.lang;

import java.lang.reflect.InvocationTargetException;

/**
 * @author Piotr Sniegowski
 */
public abstract class Numbers {

	@SuppressWarnings("unchecked")
	public static <T> T parse(String value, Class<T> type) {
		if (!Strings.notEmpty(value)) {
			return null;
		}
		try {
			return (T)type.getMethod("valueOf", String.class).invoke(null, value);
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			if (e.getTargetException() instanceof NumberFormatException) {
				return null;
			}
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (NumberFormatException ignored) {
			return null;
		}
		return null;
	}

	// @SuppressWarnings("unchecked")
	// public static <T> T parse(String value, Class<T> type) {
	// 	return null;
	// }


	public static <T extends Number> T cast(Object value, Class<T> type) {
		if (value == null) {
			return null;
		}
		if (value instanceof String) {
			return parse((String)value, type);
		}
		if (value.getClass() == type) {
			return type.cast(value);
		}
		return null;
	}

}
