package com.framsticks.util.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.apache.commons.collections.functors.InstanceofPredicate;
import org.apache.commons.collections.functors.NotPredicate;
import org.apache.commons.collections.iterators.FilterIterator;

import com.framsticks.util.Builder;
import com.framsticks.util.FramsticksException;

/**
 * @author Piotr Sniegowski
 */
public abstract class Containers {
	public static void resizeList(List<?> list, int size) {
		while (list.size() < size) {
			list.add(null);
		}
		while (list.size() > size) {
			list.remove(list.size() - 1);
		}
	}

	public static <T> Iterable<T> filterInstanceof(Iterator<? super T> i, Class<T> type) {
		return new IterableIterator<T>(new FilterIterator(i, new InstanceofPredicate(type)));
	}

	public static <T> Iterable<T> filterInstanceof(Iterable<? super T> i, Class<T> type) {
		return new IterableIterator<T>(new FilterIterator(i.iterator(), new InstanceofPredicate(type)));
	}

	public static <T> Iterable<T> filterInstanceof(Collection<? super T> c, Class<T> type) {
		return new IterableIterator<T>(new FilterIterator(c.iterator(), new InstanceofPredicate(type)));
	}

	public static <T> Iterable<T> filterNotInstanceof(Collection<T> c, Class<? extends T> type) {
		return new IterableIterator<T>(new FilterIterator(c.iterator(), new NotPredicate(new InstanceofPredicate(type))));
	}

	public static <T> T getFromList(List<T> list, int number, String name, Object context) {
		if (number < 0 || number >= list.size()) {
			throw new FramsticksException().msg("invalid " + name + " number").arg("number", number).arg("in", context);
		}
		return list.get(number);
	}

	public static <T> List<T> build(List<? extends Builder<T>> builders) {
		List<T> result = new ArrayList<T>();
		for (Builder<T> builder : builders) {
			result.add(builder.finish());
		}
		return result;
	}

	@SafeVarargs
	public static <K> Map<K, Object> buildMap(Pair<K, ? extends Object> ... pairs) {
		Map<K, Object> map = new TreeMap<>();
		for (Pair<K, ? extends Object> p : pairs) {
			map.put(p.first, p.second);
		}
		return map;
	}
}
