package com.framsticks.util.dispatching;

import com.framsticks.util.ExceptionHandler;
import com.framsticks.util.FramsticksException;

public abstract class RunAt<C> implements ExceptionHandler, Runnable {

	protected final ExceptionHandler handler;

	public RunAt(ExceptionHandler handler) {
		assert handler != null;
		this.handler = handler;
	}

	protected abstract void runAt();

	public final void run() {
		try {
			runAt();
		} catch (FramsticksException e) {
			handle(e);
		}
	}



	@Override
	public final void handle(FramsticksException exception) {
		handler.handle(exception);
	}

}
