package com.framsticks.util.dispatching;

import com.framsticks.util.ExceptionHandler;
import com.framsticks.util.FramsticksException;

public abstract class Future<T> extends FutureHandler<T> {

	protected final ExceptionHandler handler;

	public Future(ExceptionHandler handler) {
		assert handler != null;
		this.handler = handler;
	}

	@Override
	public final void handle(FramsticksException exception) {
		handler.handle(exception);
	}

	public static <T> Future<T> doNothing(Class<T> type, ExceptionHandler handler) {
		return doNothing(handler);
	}

	public static <T> Future<T> doNothing(ExceptionHandler handler) {
		return new Future<T>(handler) {

			@Override
			protected void result(T result) {

			}
		};
	}

}
