package com.framsticks.util.dispatching;


/**
 * @author Piotr Sniegowski
 */
public class AtOnceDispatcher<C> extends AbstractJoinable implements Dispatcher<C> {

	@SuppressWarnings("rawtypes")
	protected static final AtOnceDispatcher instance = new AtOnceDispatcher();

	@SuppressWarnings("unchecked")
	public static <C> Dispatcher<C> getInstance() {
		return (Dispatcher<C>) instance;
	}

	@Override
	public final boolean isActive() {
		return true;
	}

	@Override
	public final void dispatch(RunAt<? extends C> runnable) {
		runnable.runAt();
	}

	@Override
	public String getName() {
		return "atonce";
	}

	@Override
	protected void joinableStart() {

	}

	@Override
	protected void joinableInterrupt() {
		finishJoinable();
	}

	@Override
	protected void joinableFinish() {

	}

	@Override
	protected void joinableJoin() throws InterruptedException {

	}

}
