package com.framsticks.util;

import java.util.ArrayList;
import java.util.List;

import com.framsticks.util.lang.Delimeted;
import com.framsticks.util.lang.Pair;

@SuppressWarnings("serial")
public class FramsticksException extends RuntimeException {

	protected List<Pair<String, Object>> arguments;
	protected String message;

	public FramsticksException() {
		super("framsticks exception");
	}

	public FramsticksException msg(String message) {
		this.message = message;
		return this;
	}

	public FramsticksException cause(Throwable cause) {
		initCause(cause);
		return this;
	}

	public FramsticksException arg(String header, Object argument) {
		if (arguments == null) {
			arguments = new ArrayList<>();
		}
		arguments.add(new Pair<String, Object>(header, argument));
		return this;
	}

	public StringBuilder getShortMessage(StringBuilder b) {
		if (message != null) {
			b.append(message);
		} else {
			b.append("?");
		}
		if (arguments != null) {
			if (message != null) {
				b.append(" ");
			}
			Delimeted<Pair<String, Object>> d = new Delimeted<>(", ", "");
			d.append(arguments.iterator());

			b.append("(").append(d.build()).append(")");
		}
		return b;
	}

	public String getMsg() {
		return message;
	}

	@Override
	public String getMessage() {
		StringBuilder b = new StringBuilder();
		getShortMessage(b);
		Throwable cause = this.getCause();
		while (cause != null) {
			b.append(" caused by: [").append(cause.getClass().getCanonicalName()).append(": ");
			if (cause instanceof FramsticksException) {
				((FramsticksException) cause).getShortMessage(b);
			} else {
				b.append(cause.getMessage());
			}
			b.append("]");
			cause = cause.getCause();
		}
		return b.toString();
	}


	public static ExceptionHandler addArgumentHandler(final ExceptionHandler innerHandler, final String header, final Object argument) {
		return new ExceptionHandler() {
			@Override
			public void handle(FramsticksException exception) {
				innerHandler.handle(exception.arg(header, argument));
			}
		};
	}

}
