package com.framsticks.test.prime;

import com.framsticks.experiment.InvalidWorkPackage;
import com.framsticks.experiment.WorkPackage;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;

@FramsClassAnnotation(order = {"params", "state"})
public class PrimePackage implements WorkPackage<PrimePackage> {

	@ParamAnnotation
	public final ExpParams params = new ExpParams();

	@ParamAnnotation
	public final ExpState state = new ExpState();

	@Override
	public String toString() {
		return params + " -> " + state;
	}

	@Override
	public String sumUpTask() {
		return params.toString();
	}

	@Override
	public String sumUpResult() {
		return state.toString();
	}

	@Override
	public String getShortDescription() {
		return params.toString();
	}

	public static PrimePackage compose(int from, int to) {
		PrimePackage wp = new PrimePackage();
		wp.params.from_number = from;
		wp.params.to_number = to;
		wp.state.current_number = from;
		return wp;
	}

	@Override
	public PrimePackage getRemainder(PrimePackage result) {
		if (!result.params.isInsideOf(params)) {
			throw new InvalidWorkPackage().msg("result is not inside of task");
		}
		if (result.params.from_number != params.from_number) {
			throw new InvalidWorkPackage().msg("result is not subpackage");
		}
		if (result.state.current_number == params.to_number + 1) {
			return null;
		}
		return compose(result.state.current_number, params.to_number);
	}
}
