package com.framsticks.test.prime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.params.types.UniversalParam;

@FramsClassAnnotation
public class ExpState {

	@ParamAnnotation
	public int current_number;

	protected final List<Integer> resultList = new ArrayList<>();

	@ParamAnnotation(paramType = UniversalParam.class)
	public List<Integer> getResult() {
		return Collections.unmodifiableList(resultList);
	}


	@ParamAnnotation(paramType = UniversalParam.class)
	public void setResult(List<Integer> list) {
		resultList.clear();
		resultList.addAll(list);
	}

	/**
	 * @return the resultList
	 */
	public List<Integer> getResultList() {
		return resultList;
	}

	@Override
	public String toString() {
		return "(" + current_number + "):" + resultList;
	}
}
