package com.framsticks.test;

import com.framsticks.params.AbstractUniqueObject;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;

@FramsClassAnnotation
public class TestChild extends AbstractUniqueObject {

	protected String name = "child";

	protected TestClass parent;

	/**
	 *
	 */
	public TestChild() {
	}

	/**
	 * @return the name
	 */
	@ParamAnnotation
	public String getName() {
		return name;
	}

	/**00:10:00
	 * @param name the name to set
	 */
	@ParamAnnotation
	public void setName(String name) {
		this.name = name;
		if (parent != null) {
			parent.children.modify(this);
		}
	}

	@Override
	public String toString() {
		return "test child " + name;
	}

}
