package com.framsticks.structure.messages;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;

@FramsClassAnnotation(id = "Msg", name = "Msg")
public class Message {

	@ParamAnnotation(id = "class", name = "class")
	public String className;

	@ParamAnnotation
	public String function;

	@ParamAnnotation
	public String message;

	@ParamAnnotation
	public int level;

	/**
	 *
	 */
	public Message() {
	}


	/**
	 * @param function
	 * @param message
	 * @param level
	 */
	public Message(String className, String function, String message, int level) {
		this.className = className;
		this.function = function;
		this.message = message;
		this.level = level;
	}

	@Override
	public String toString() {
		StringBuilder b = new StringBuilder();
		b.append("[").append(level).append("] ");
		b.append(className).append(".").append(function);
		b.append(": ").append(message);
		return b.toString();
	}
}
