package com.framsticks.standard;

import java.util.ArrayList;
import java.util.List;

import com.framsticks.experiment.NetFile;
import com.framsticks.model.Creature;
import com.framsticks.model.Genotype;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;

@FramsClassAnnotation(register = {Genotype.class, Creature.class}, registerFromInfo = {"Population", "GenePool"})
public class StandardState implements NetFile {

	@ParamAnnotation(stringType = "o sim_params")
	public Object simParams;

	@ParamAnnotation(stringType = "l GenePool")
	public final List<Object> genepools = new ArrayList<>();

	@ParamAnnotation(stringType = "l Population")
	public final List<Object> populations = new ArrayList<>();

	@Override
	public String getShortDescription() {
		return genepools.size() + " genepools, " + populations.size() + " populations";
	}

	@Override
	public String toString() {
		return getShortDescription();
	}
}
