package com.framsticks.parsers;

import javax.annotation.Nonnull;

import com.framsticks.params.*;
// import org.apache.logging.log4j.Logger;

/**
 * @author Piotr Sniegowski
 */
public class Loaders {

	// private static final Logger log = LogManager.getLogger(Loaders.class.getName());

	public static @Nonnull FramsClass loadFramsClass(Source source) throws ConstructionException {
		final MultiParamLoader loader = new MultiParamLoader();
		loader.setNewSource(source);

		final FramsClassBuilder builder = FramsClass.build();

		final Access framsClassAccess = new ReflectionAccess(FramsClassBuilder.class, FramsClass.build().forClass(FramsClassBuilder.class));
		Access paramBuilderAccess = new ReflectionAccess(ParamBuilder.class, FramsClass.build().forClass(ParamBuilder.class));
		framsClassAccess.select(builder);
		loader.setAccessProvider(new AccessStash().add(framsClassAccess).add(paramBuilderAccess));

		loader.addListener(MultiParamLoader.Status.AfterObject, new MultiParamLoader.StatusListener() {
			@Override
			public void onStatusChange() {
				Object object = loader.returnObject();
				if (object instanceof FramsClassBuilder) {
					return;
				}
				framsClassAccess.select(builder).tryAutoAppend(object);
				// throw new ConstructionException().msg("failed to interpretate object").arg("object", object);

			}
		});

		try {
			loader.go();
			return builder.finish();
		} catch (Exception e) {
			throw new ConstructionException().msg("an error occurred while loading class description").arg("before", loader.getCurrentLine()).cause(e);
		}
	}
}
