package com.framsticks.params.types;

import com.framsticks.params.CastFailure;
import com.framsticks.params.ParamBuilder;
import com.framsticks.params.PrimitiveParam;
import com.framsticks.params.ReassignResult;

import javax.annotation.concurrent.Immutable;

/**
 * @author Piotr Sniegowski
 */
@Immutable
public class StringParam extends PrimitiveParam<String> {



	/**
	 * @param builder
	 */
	public StringParam(ParamBuilder builder) {
		super(builder);
	}

	@Override
	public Class<?> getStorageType() {
		return String.class;
	}

	@Override
	public ReassignResult<String> reassign(Object newValue, Object oldValue) throws CastFailure {
		if (newValue == null) {
			return new ReassignResult<String>(null);
		}
		if (newValue instanceof String) {
			return ReassignResult.create((String) newValue);
		}
		return ReassignResult.create(newValue.toString());
		// return super.reassign(newValue, oldValue);
	}

	@Override
	public String getFramsTypeName() {
		return "s";
	}

	private static final String SEPARATOR = System.getProperty("line.separator");

	@Override
	public String serialize(Object value) {
		if (value == null) {
			return "";
		}
		assert value instanceof String;
		String s = (String) value;
		return (s.contains(SEPARATOR) ? (s = "~" + SEPARATOR + s + "~") : s);
	}
}
