package com.framsticks.params.types;

import com.framsticks.params.CastFailure;
import com.framsticks.params.ParamBuilder;
import com.framsticks.params.PrimitiveParam;
import com.framsticks.params.ReassignResult;
import com.framsticks.util.lang.Casting;
import com.framsticks.util.lang.Numbers;

import javax.annotation.concurrent.Immutable;
import static com.framsticks.params.SetStateFlags.*;

/**
 * @author Piotr Sniegowski
 */
@Immutable
public abstract class NumberParam<T extends Number & Comparable<T>> extends PrimitiveParam<T> {

	/**
	 * @param builder
	 */
	public NumberParam(ParamBuilder builder) {
		super(builder);
	}

	@Override
	public boolean isNumeric() {
		return true;
	}

	protected ReassignResult<T> reassignNumber(Object newValue, Object oldValue, Class<T> type) throws CastFailure {
		T v = null;
		if (newValue instanceof String) {
			v = Numbers.parse((String) newValue, type);
		} else {
			v = Casting.tryCast(type, newValue);
		}
		if (v == null) {
			throw new CastFailure();
		}
		if (min != null && v.compareTo(getMin(type)) < 0) {
			return new ReassignResult<T>(getMin(type), PSET_HITMIN);
		}
		if (max != null && v.compareTo(getMax(type)) > 0) {
			return new ReassignResult<T>(getMax(type), PSET_HITMAX);
		}
		return ReassignResult.create(v);
	}
}
