package com.framsticks.params.types;

import com.framsticks.params.Param;
import com.framsticks.params.ParamBuilder;

import javax.annotation.concurrent.Immutable;

/**
 * @author Piotr Sniegowski
 */
@Immutable
public class EventParam extends Param {

	protected final String eventArgumentTypeName;


	/**
	 * @param builder
	 */
	public EventParam(ParamBuilder builder) {
		super(builder);
		eventArgumentTypeName = builder.getEventArgumentTypeName();
	}

	@Override
	public String getFramsTypeName() {
		return eventArgumentTypeName != null ? "e " + eventArgumentTypeName : "e";
	}
}
