package com.framsticks.params.types;

import com.framsticks.params.CastFailure;
import com.framsticks.params.ParamBuilder;
import com.framsticks.params.ReassignResult;

import javax.annotation.concurrent.Immutable;

/**
 * @author Piotr Sniegowski
 */
@Immutable
public class DecimalParam extends NumberParam<Integer> {

	/**
	 * @param builder
	 */
	public DecimalParam(ParamBuilder builder) {
		super(builder.fillDef(0).fillStorageType(Integer.class));
	}

	@Override
	public Class<?> getStorageType() {
		return Integer.class;
	}

	@Override
	public ReassignResult<Integer> reassign(Object newValue, Object oldValue) throws CastFailure {
		return reassignNumber(newValue, oldValue, Integer.class);
	}

	@Override
	public String getFramsTypeName() {
		return "d";
	}


}
