package com.framsticks.params.types;

import com.framsticks.params.CastFailure;
import com.framsticks.params.ParamBuilder;
import com.framsticks.params.PrimitiveParam;
import com.framsticks.params.ReassignResult;

import javax.annotation.concurrent.Immutable;

/**
 * @author Piotr Sniegowski
 */
@Immutable
public class ColorParam extends PrimitiveParam<Object> {



	/**
	 * @param builder
	 */
	public ColorParam(ParamBuilder builder) {
		super(builder);
	}

	@Override
	public Class<?> getStorageType() {
		return Object.class;
	}

	@Override
	public String getFramsTypeName() {
		return "dc";
	}

	public ReassignResult<Object> reassign(Object newValue, Object oldValue) throws CastFailure {
		return ReassignResult.create(newValue);
	}


}
