package com.framsticks.params.types;

import javax.annotation.concurrent.Immutable;

import com.framsticks.params.CastFailure;
import com.framsticks.params.ParamBuilder;
import com.framsticks.params.PrimitiveParam;
import com.framsticks.params.ReassignResult;
import com.framsticks.util.lang.Numbers;

/**
 * @author Piotr Sniegowski
 */
@Immutable
public class BooleanParam extends PrimitiveParam<Boolean> {

	/**
	 * @param builder
	 */
	public BooleanParam(ParamBuilder builder) {
		super(builder.fillDef(false).fillStorageType(Boolean.class));
	}

	@Override
	public Class<?> getStorageType() {
		return Boolean.class;
	}

	@Override
	public ReassignResult<Boolean> reassign(Object newValue, Object oldValue) throws CastFailure {
		if (newValue instanceof Boolean) {
			return ReassignResult.create((Boolean) newValue);
		}
		if (newValue instanceof Integer) {
			return ReassignResult.create(((Integer) newValue) != 0);
		}
		if (newValue instanceof String) {
			if ("true".equals(newValue)) {
				return ReassignResult.create(true);
			}
			if ("false".equals(newValue)) {
				return ReassignResult.create(false);
			}
			Integer i = Numbers.cast(newValue, Integer.class);
			if (i != null) {
				return ReassignResult.create(i != 0);
			}
			throw new CastFailure();
		}
		throw new CastFailure();
	}

	@Override
	public String getFramsTypeName() {
		return "d 0 1";
	}

	@Override
	public String serialize(Object value) {
		assert value instanceof Boolean;
		return ((Boolean)value) ? "1" : "0";
	}
}
